%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This is French class file.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{ISTE}[2016/25/11 \space 0.1]

% Are we printing crop marks?
\setlength{\paperheight}{210truemm}
\setlength{\paperwidth}{297truemm}

\DeclareOption{fleqn}{\PassOptionsToPackage{fleqn}{amsmath}}
\PassOptionsToClass{12pt,twoside,fleqn}{book}
\ExecuteOptions{12pt}         % Defaults options
\ProcessOptions
\LoadClass{book}

\RequirePackage[T1]{fontenc}
\RequirePackage{graphicx,graphics}
\RequirePackage{latexsym,times,epsfig,indentfirst}
\RequirePackage[intlimits,sumlimits,namelimits,fleqn]{amsmath}
\RequirePackage{amssymb,amscd,amsthm,amsfonts,mathrsfs,array,anyfontsize,ifthen}
\RequirePackage{geometry,float}
\geometry{
a4paper,total={190truemm,265truemm},left=10truemm, right=10truemm}
\RequirePackage{fancyhdr}
\fancyhf{}
\rhead{ }
\lhead{ }
\rfoot{\fontsize{8}{10}\selectfont\textcolor{gray}{\copyright\, 2017 ISTE  OpenScience -- Published by ISTE Ltd. London, UK -- openscience.fr\hfill Page \ |\ \thepage}}
\RequirePackage[table]{xcolor}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%new color for french article
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\definecolor{AtBlue}{cmyk}{0.76,0.53,0.04,0.41}
\definecolor{AstBlue}{cmyk}{0.76,0.53,0.04,0.41}
\definecolor{AbsBlue}{cmyk}{0.76,0.53,0.04,0.41}
\definecolor{AbsboxBlue}{cmyk}{0.13,0.05,0.02,0.00}
\definecolor{SecoBlue}{cmyk}{0.76,0.53,0.04,0.41}
\definecolor{SectBlue}{cmyk}{0.76,0.53,0.04,0.41}
\definecolor{SecthBlue}{cmyk}{0.76,0.53,0.04,0.41}
\definecolor{SecfBlue}{cmyk}{0.76,0.53,0.04,0.41}
\definecolor{TableBlue}{cmyk}{0.76,0.53,0.04,0.41}
\definecolor{BibBlue}{cmyk}{0.76,0.53,0.04,0.41}
\definecolor{FigureBrown}{cmyk}{0.30,0.95,0.89,0.36}
\definecolor{TableBlue}{cmyk}{0.76,0.53,0.04,0.41}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\definecolor{Blue}{RGB}{0,0,177}
\definecolor{BBlue}{RGB}{218,229,239}
%\definecolor{chapBlue}{RGB}{0,32,96}
\definecolor{chapBlue}{RGB}{32,60,105}
\definecolor{darkBlue}{RGB}{0,32,96}
\definecolor{shadecolor}{RGB}{219,229,241}
\definecolor{figcapcolor}{RGB}{128,0,0}
\definecolor{remblue}{RGB}{255,255,255}
\definecolor{seccol}{RGB}{32,25,163}
\definecolor{bibcol}{RGB}{32,25,163}
\definecolor{tabcol}{RGB}{229,223,236}
\definecolor{DarkBlue}{RGB}{42,47,96}
\definecolor{TabBrown}{RGB}{128,33,33}
\definecolor{TitleBlue}{cmyk}{0.79,0.67,0.00,0.56}
%\definecolor{AbsBlue}{cmyk}{0.13,0.05,0.02,0}


%\definecolor{AbshBlue}{cmyk}{0.95,0.72,0.25,0.1}
\definecolor{AbshBlue}{cmyk}{0.99,0.98,0.01,0.00}
\definecolor{HeadBlue}{cmyk}{0.95,.72,.25,.10}
\definecolor{FigBrown}{cmyk}{0.29,1,1,.40}
\definecolor{Tc}{cmyk}{0.99,0.98,0.01,0.00}
%\definecolor{Tch}{cmyk}{1,0.9,0.36,0.28}
%\definecolor{Tb}{cmyk}{0.12,0.13,0.04,0.00}
\definecolor{Tch}{cmyk}{0.79,0.67,0.00,0.56}
\definecolor{Tb}{cmyk}{0.07,0.09,0.00,0.02}
%\definecolor{fTb}{cmyk}{0.07,0.09,0.00,0.02}
%\definecolor{FigBrown}{cmyk}{0.29,1,1,.40}
\definecolor{FigBrown}{cmyk}{0.30,0.95,0.89,0.36}
\definecolor{YBox}{cmyk}{0.02,0,0.2,0}
\RequirePackage{remreset}
\newcommand{\typearea}{\RequirePackage{showframe}}
\RequirePackage{sectsty}
\sectionfont{\sffamily\color{TitleBlue}}
\subsectionfont{\sffamily\color{AbshBlue}}
\subsubsectionfont{\sffamily\color{AbshBlue}}
\allowdisplaybreaks

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Fontsize
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\ts#1{\textsuperscript {#1}}
\makeatletter
\gdef\defaultsize{%
   \@setfontsize\defaultsize{13\p@}{17\p@}%
   \abovedisplayskip 10\p@ \@plus2\p@ \@minus5\p@
   \abovedisplayshortskip \z@ \@plus3\p@
   \belowdisplayshortskip 6\p@ \@plus3\p@ \@minus3\p@
   \belowdisplayskip \abovedisplayskip
   \let\@listi\@listI}\defaultsize
\makeatother \defaultsize
\let\normalsize\defaultsize
\def\Bsize{%
  \@setfontsize\Bsize{9\p@}{10\p@}%
  \abovedisplayskip 10\p@ \@plus 3\p@ \@minus1\p@
  \abovedisplayshortskip \z@ \@plus 3\p@
  \belowdisplayshortskip 5\p@ \@plus 3\p@ \@minus1\p@
  \belowdisplayskip \abovedisplayskip
  \let\@listi\@listI}
%\normalsize
\makeatletter


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Table and captions
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%\newlength\abovecaptionskip
%\newlength\belowcaptionskip
\setlength\abovecaptionskip{10\p@}
\setlength\belowcaptionskip{0\p@}
\long\def\@makecaption#1#2{%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{#1\textcolor{FigureBrown}{\textbf{:}} #2}%
  \ifdim \wd\@tempboxa >\hsize
    #1\textcolor{FigureBrown}{\textbf{:}} #2\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}
  \makeatother


\makeatletter
%\def\fnum@figure{\fontsize{11}{13}\selectfont\textcolor{TabBrown}{\textbf{Figure~3.1}}}
\def\tablename{\textcolor{TableBlue}{Table}\color{TableBlue}}
%\def\fnum@table{\tablename\nobreakspace\textcolor{blue}{\thetable}\normalcolor}
\def\fnum@table{\tablename\nobreakspace\thetable\normalcolor}
\makeatother


\makeatletter
%\begin{table}
%\caption{This is caption}
%\end{table}
%fksdflfksalfsfkasfkfl
%\end{document}
%\renewcommand{\thefootnote}{\fnsymbol{footnote}}
\setlength{\skip\footins}{24pt}
\long\def\@makefntext#1{\parindent 1em\noindent
            \hb@xt@1.8em{%
                \hss{\normalfont\@thefnmark.}}#1}
%\setlength\footskip{100pt}%{11.99truemm}
\makeatother

\setlength{\parskip}{9pt}
\setlength\parindent{10pt}

\definecolor{Bibref}{cmyk}{0.99,0.98,0.01,0}
\definecolor{Eqref}{cmyk}{0.99,0.98,0.01,0}
\def\Bl #1{\color{Bibref}#1\normalcolor}
\def\El #1{\color{Eqref}#1\normalcolor}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Opening Page
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%
\makeatletter
\def\FontTitle{\@setfontsize\FontTitle{22pt}{28pt}}
\def\FontSubtitle{\@setfontsize\FontTitle{18pt}{20pt}}
%\def\FontTitle#1{\fontfamily{phv}\selectfont{\fontsize{22}{28}\selectfont{{\textcolor{TitleBlue}{#1}}}}}
%\def\FontChapter#1{\fontfamily{phv}\selectfont{\fontsize{18}{20}\selectfont{\bfseries{#1}}}}
\def\FontAuthor#1{\fontfamily{phv}\selectfont{\fontsize{13}{15}\selectfont{{#1}}}}
\def\FontAff#1{\fontfamily{phv}\selectfont{\fontsize{10}{12}\selectfont{{#1}}}}
\def\FontBib#1{\fontfamily{phv}\selectfont{\fontsize{18}{20}\selectfont{{\textcolor{HeadBlue}{#1}}}}}
\def\FontArial#1{\fontfamily{arial}\selectfont{\fontsize{13}{15}\selectfont{{#1}}}}



\renewcommand*\chapter{\clearpage \thispagestyle{headings} \global\@topnum\z@
  \@afterindentfalse \secdef\@chapter\@schapter}

\def\@chapter[#1]#2{%
  \ifnum \c@secnumdepth >\m@ne
    \refstepcounter{chapter}
    \typeout{^^J\@chapapp\space\arabic{chapter}:}
    \addcontentsline{toc}{chapter}{\protect\numberline{\thechapter}#2}
  \else
    \addcontentsline{toc}{chapter}{#2}
  \fi
%  \chaptermark{#1}
  \@makechapterhead{#2}
  \@afterindentfalse
  \@afterheading}

%\let\@abstract\@empty%
\def\abstract#1{\def\@abstract{#1}}%
\def\resu#1{\def\@resu{#1}}%

%\let\@para\@empty%
\def\para#1{\def\@para{#1}}%

%\let\@kwd\@empty%
\def\kwd#1{\def\@kwd{#1}}%
\def\moi#1{\def\@moi{#1}}%


\def\@schapter#1{%
%  \chaptermark{#1}
  \@makeschapterhead{#1}
  \@afterindentfalse
  \@afterheading}

\def\@subh{} \newcounter{subh}
\def\@authm{} \newcounter{authm}
\def\@affm{} \newcounter{affm}

\newcounter{subhcnt}
\setcounter{subhcnt}{0}
\newcounter{authorcnt}
\setcounter{authorcnt}{0}
\newcounter{affcnt}
\setcounter{affcnt}{0}
\def\SP#1#2{\vrule height#1pt width0pt depth#2pt}
%%%%%%%%%%%%%
\newcommand{\subh}[1]{\refstepcounter{subhcnt}
\ifthenelse{\equal{\value{subhcnt}}{1}}{\gdef\@subh{\FontSubtitle\selectfont\raggedright\textcolor{AstBlue}{#1}\vphantom{y}}}{\relax}%
%\ifthenelse{\equal{\value{authorcnt}}{2}}{\gdef\@autht{\fontsize{10}{11}\fontshape{roman}\selectfont\raggedright\SP{16}{0}#1\vphantom{y}}}{\relax}%
%\ifthenelse{\equal{\value{authorcnt}}{3}}{\gdef\@authth{\fontsize{10}{11}\fontshape{roman}\selectfont\raggedright\SP{16}{0}#1\vphantom{y}}}{\relax}%
%\ifthenelse{\equal{\value{authorcnt}}{4}}{\gdef\@authf{\fontsize{10}{11}\fontshape{roman}\selectfont\raggedright\SP{16}{0}#1\vphantom{y}}}{\relax}%
%\ifthenelse{\equal{\value{authorcnt}}{5}}{\gdef\@authfi{\fontsize{10}{11}\fontshape{roman}\selectfont\raggedright\SP{16}{0}#1\vphantom{y}}}{\relax}%
%\ifthenelse{\equal{\value{authorcnt}}{6}}{\gdef\@auths{\fontsize{10}{11}\fontshape{roman}\selectfont\raggedright\SP{16}{0}#1\vphantom{y}}}{\relax}%
%\ifthenelse{\equal{\value{authorcnt}}{7}}{\gdef\@authse{\fontsize{10}{11}\fontshape{roman}\selectfont\raggedright\SP{16}{0}#1\vphantom{y}}}{\relax}%
%\ifthenelse{\equal{\value{authorcnt}}{8}}{\gdef\@authei{\fontsize{10}{11}\fontshape{roman}\selectfont\raggedright\SP{16}{0}#1\vphantom{y}}}{\relax}%
%\ifthenelse{\equal{\value{authorcnt}}{9}}{\gdef\@authni{\fontsize{10}{11}\fontshape{roman}\selectfont\raggedright\SP{16}{0}#1\vphantom{y}}}{\relax}%
%\ifthenelse{\equal{\value{authorcnt}}{10}}{\gdef\@authten{\fontsize{10}{11}\fontshape{roman}\selectfont\raggedright\SP{16}{0}#1\vphantom{y}}}{\relax}%
}

\renewcommand{\author}[1]{\refstepcounter{authorcnt}
\ifthenelse{\equal{\value{authorcnt}}{1}}{\gdef\@authm{\FontAuthor\selectfont\raggedright#1\color{black}\vphantom{y}}}{\relax}%
%\ifthenelse{\equal{\value{authorcnt}}{2}}{\gdef\@autht{\fontsize{10}{11}\fontshape{roman}\selectfont\raggedright\SP{16}{0}#1\vphantom{y}}}{\relax}%
%\ifthenelse{\equal{\value{authorcnt}}{3}}{\gdef\@authth{\fontsize{10}{11}\fontshape{roman}\selectfont\raggedright\SP{16}{0}#1\vphantom{y}}}{\relax}%
%\ifthenelse{\equal{\value{authorcnt}}{4}}{\gdef\@authf{\fontsize{10}{11}\fontshape{roman}\selectfont\raggedright\SP{16}{0}#1\vphantom{y}}}{\relax}%
%\ifthenelse{\equal{\value{authorcnt}}{5}}{\gdef\@authfi{\fontsize{10}{11}\fontshape{roman}\selectfont\raggedright\SP{16}{0}#1\vphantom{y}}}{\relax}%
%\ifthenelse{\equal{\value{authorcnt}}{6}}{\gdef\@auths{\fontsize{10}{11}\fontshape{roman}\selectfont\raggedright\SP{16}{0}#1\vphantom{y}}}{\relax}%
%\ifthenelse{\equal{\value{authorcnt}}{7}}{\gdef\@authse{\fontsize{10}{11}\fontshape{roman}\selectfont\raggedright\SP{16}{0}#1\vphantom{y}}}{\relax}%
%\ifthenelse{\equal{\value{authorcnt}}{8}}{\gdef\@authei{\fontsize{10}{11}\fontshape{roman}\selectfont\raggedright\SP{16}{0}#1\vphantom{y}}}{\relax}%
%\ifthenelse{\equal{\value{authorcnt}}{9}}{\gdef\@authni{\fontsize{10}{11}\fontshape{roman}\selectfont\raggedright\SP{16}{0}#1\vphantom{y}}}{\relax}%
%\ifthenelse{\equal{\value{authorcnt}}{10}}{\gdef\@authten{\fontsize{10}{11}\fontshape{roman}\selectfont\raggedright\SP{16}{0}#1\vphantom{y}}}{\relax}%
}
%%%%%%%%%%%%%%
\newcommand{\aff}[1]{\refstepcounter{affcnt}
\ifthenelse{\equal{\value{affcnt}}{1}}{\gdef\@affm{\FontAff\raggedright\selectfont\SP{8}{0}#1}}{\relax}%
%\ifthenelse{\equal{\value{affcnt}}{2}}{\gdef\@afft{\fontsize{8.5}{9.5}\fontshape{it}\raggedright\selectfont\SP{8}{0}#1}}{\relax}%
%\ifthenelse{\equal{\value{affcnt}}{3}}{\gdef\@affth{\fontsize{8.5}{9.5}\fontshape{it}\raggedright\selectfont\SP{8}{0}#1}}{\relax}%
%\ifthenelse{\equal{\value{affcnt}}{4}}{\gdef\@afff{\fontsize{8.5}{9.5}\fontshape{it}\raggedright\selectfont\SP{8}{0}#1}}{\relax}%
%\ifthenelse{\equal{\value{affcnt}}{5}}{\gdef\@afffi{\fontsize{8.5}{9.5}\fontshape{it}\raggedright\selectfont\SP{8}{0}#1}}{\relax}%
%\ifthenelse{\equal{\value{affcnt}}{6}}{\gdef\@affs{\fontsize{8.5}{9.5}\fontshape{it}\raggedright\selectfont\SP{8}{0}#1}}{\relax}%
%\ifthenelse{\equal{\value{affcnt}}{7}}{\gdef\@affse{\fontsize{8.5}{9.5}\fontshape{it}\raggedright\selectfont\SP{8}{0}#1}}{\relax}%
%\ifthenelse{\equal{\value{affcnt}}{8}}{\gdef\@affei{\fontsize{8.5}{9.5}\fontshape{it}\raggedright\selectfont\SP{8}{0}#1}}{\relax}%
%\ifthenelse{\equal{\value{affcnt}}{9}}{\gdef\@affni{\fontsize{8.5}{9.5}\fontshape{it}\raggedright\selectfont\SP{8}{0}#1}}{\relax}%
%\ifthenelse{\equal{\value{affcnt}}{10}}{\gdef\@afften{\fontsize{8.5}{9.5}\fontshape{it}\raggedright\selectfont\SP{8}{0}#1}}{\relax}%
}

\def\@makechapterhead#1#2{%
  \begingroup\sffamily
    \parindent\z@
%\twocolumn
%[\vskip-5.9truemm
%\vbox{\parindent\z@\raggedleft\footnotesize\sf\fontshape{it}\selectfont
%{Computational Vision and Medical Image Processing -- Jo\~{a}o
%Tavares \& Natal Jorge (eds)}\par {\textcopyright\ 2010 Taylor \&
%Francis Group, London, ISBN 978-0-415-57041-1}\par}
%\removelastskip\vskip8truemm\removelastskip%
    %{\fontsize{13}{15}\selectfont\raggedright#1\vphantom{y}\par}
    \def\FontTitle{\@setfontsize\FontTitle{22\p@}{25.5\p@}\sffamily}
    \def\FontSubtitle{\@setfontsize\FontTitle{18\p@}{20\p@}\sffamily}
    \def\FontAuthor{\@setfontsize\FontAuthor{13\p@}{15\p@}\sffamily}
    \def\FontAff{\@setfontsize\FontAuthor{10\p@}{12\p@}\sffamily}
%
%%\def\FontTitle#1{\fontfamily{phv}\selectfont{\fontsize{22}{28}\selectfont{{\textcolor{TitleBlue}{#1}}}}}
%%\def\FontChapter#1{\fontfamily{phv}\selectfont{\fontsize{18}{20}\selectfont{\bfseries{#1}}}}
%\def\FontAuthor#1{\fontfamily{phv}\selectfont{\fontsize{13}{15}\selectfont{{#1}}}}
%\def\FontAff#1{\fontfamily{phv}\selectfont{\fontsize{10}{12}\selectfont{{#1}}}}
%\def\FontBib#1{\fontfamily{phv}\selectfont{\fontsize{18}{20}\selectfont{{\textcolor{HeadBlue}{#1}}}}}
%\def\FontArial#1{\fontfamily{arial}\selectfont{\fontsize{13}{15}\selectfont{{#1}}}}
{\FontTitle\raggedright\textcolor{AtBlue}{#1}\vphantom{y}\par}
    \removelastskip\vskip9.3\p@\nointerlineskip
%{\FontSubtitle\raggedright\textcolor{TitleBlue}{#2}\vphantom{y}\par}
\bgroup
\@subh\par
\vspace*{25\p@}
\@authm\par
\vspace*{6\p@}
\@affm\par
\egroup
\vspace*{-22.22\p@}\vspace*{12pt}%
%%%Loga turnoff the below commands
%%{\parindent10pt\noindent\fontsize{9}{10}\selectfont
%%{\MakeUppercase{Abstract:}}\ignorespaces\quad\ignorespaces
%%\@abstract
%%\par}%
%\vspace*{11\p@}%
%{\if!\relax\else\noindent\fontsize{9}{10}\selectfont{{\it Keywords}:\quad }\@kwd\fi\par}%
%\begin{tabular}{@{}p{0.99\textwidth}@{}}
%\hline
%\colorbox{AbsBlue}{\fontsize{10}{12}\selectfont\vbox{\textcolor{AbsBlue}{.}\newline \textbf{\textcolor{AbshBlue}{RÉSUMÉ.}}\hphantom{--}
\noindent\null \hrulefill\null\\[-1pt]
\hbox to \textwidth{\sffamily\colorbox{AbsboxBlue}{\fontsize{10}{12}\selectfont\parbox{0.99\textwidth}{\vspace*{2mm}\textcolor{AbsBlue}{\textbf{\MakeUppercase\abstractname.}}\hphantom{--}
\@resu\par
\textcolor{AbsBlue}{\textbf{ABSTRACT.}}\hphantom{--}
\@abstract%\vspace*{10pt}

\@moi\par
\textbf{\textcolor{AbsBlue}{KEYWORDS.}}\hphantom{--} \@kwd
%\newline\vskip-7mm\textcolor{AbsBlue}{.}
}}}\\[-1pt]
\null\hrulefill\null

\removelastskip\nointerlineskip\vspace*{15.5\p@}\par %plus3\p@ minus1\p@}\par%
%\removelastskip\nointerlineskip\vspace*{27.5\p@}\par %plus3\p@ minus1\p@}\par%
%]
\par  \endgroup%
  \@afterindentfalse%
  \@afterheading%
  \thispagestyle{fancy}}
  \makeatother

  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Title
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%\FontTitle {Controlling the spurious oscillations in a  least \\[3pt]squares formulation  of the transport equation \\[3pt]approximated with space-time finite element}\\[18pt]
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Autor,affiliations
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%\FontAuthor{Khadidja Benmansour\ts{1}, Elie Bretin\ts{2}, Loic Piffet\ts{3}, Jérôme Pousin\ts{4}\color{white}\footnote{\looseness-1This work was supported by the LABEX MILYON (ANR-10-LABX-0070) of Universit\'e de Lyon, within the program "\mbox{Investissements} d'Avenir" (ANR-11-IDEX-0007) operated by the French National Research Agency (ANR); and by  ANR 11-TecSan002-03.}\vspace*{3truemm}}
%\FontAff{\removelastskip \ts{1}Universit\'e Abou Bekr Belkaid de Tlemcen,
%Universit\'e de Tlemcen BP 119
%Alg\'erie, jija\_tlm@yahoo.fr} \\
%\FontAff{ %\small
%\vbox{\ts{2,3,4}Universit\'e de Lyon UMR-CNRS 5208 Institut Camille Jordan,
%20 av. A. Einstein F-69100 Villeurbanne,\\ elie.bretin@insalyon.fr, loic.piffet@yahoo.fr, jerome.pousin@insa-lyon.fr \vspace*{13pt}} }
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Abstract
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%\begin{tabular}{@{}p{0.99\textwidth}@{}}
%\hline
%\colorbox{AbsBlue}{\fontsize{10}{12}\selectfont\vbox{\textcolor{AbsBlue}{.}\newline \textbf{\textcolor{AbshBlue}{ABSTRACT.}}\hphantom{--} Finite element methods are known to produce spurious oscillations when the transport equation is solved. In this paper, a variational formulation for the transport equation is proposed, and by introducing  extremal values constraints combined with a penalization of the total variation of the solution, the spurious oscillations are cancelled  for a  first order Lagrange finite element method.\vspace*{10pt}
%
%\textbf{\textcolor{AbshBlue}{KEYWORDS.}}\hphantom{--} Transport equation; space-time formulation; Least squares; Total variation; Finite element;
%numerical \break oscillations; constrained optimization; image processing
%%\newline\vskip-7mm\textcolor{AbsBlue}{.}
%}}\\[-0pt]
%\hline
%\end{tabular}


\newcommand{\deri}[2]{\partial_{#1} \, {#2}}
\newcommand{\setof}[1]{\left\{ {#1} \right\}}
\newcommand{\prodscal}[2]{\left( \, {#1} \, | \, {#2} \, \right)}
\newcommand{\nor}[1]{\left\| {#1} \right\|}
%
\newcommand{\nortb}[1]{||| {#1} |||}
%
\newcommand{\norml}[2]{\left\| {#1} \right\|_{L^2({#2})}}
%
\newcommand{\normh}[2]{\left\| {#1} \right\|_{H^{-1}({#2})}}
%
\newcommand{\normd}[2]{\left\| {#1} \right\|_{L^2(\partial{#2})}}
\newcommand{\derp}[2]{\frac{\partial{#1}}{\partial{#2}}}
\newcommand{\derpd}[2]{\frac{\partial^{2}{#1}}{\partial{#2}^{2}}}
%
\def\IR{\mathbb{R}}
\def\IN{\mathbb{N}}
\def\IM{\mathbb{M}}
\def\divg{\mathop{\rm div}\nolimits}
\def\utld{\widetilde{u}}
\def\ctld{\overline{C}}
\def\Btld{\overline{B}}
\def\ntld{\widetilde{n}}
\def\nabtld{\widetilde{\nabla}}
\def\divtld{\widetilde{\divg}}
\def\sigtld{\widetilde{\sigma}}
\newcommand{\dive}[1]{\text{ div }( {#1} )}

\newtheorem{algo}{Algorithm}[section]
\def\vtld{\widetilde{v}}



\newtheorem{theorem}{Theorem}[section]
\newtheorem{lemma}[theorem]{Lemma}

%\theoremstyle{definition}
\newtheorem{definition}[theorem]{Definition}
\newtheorem{example}[theorem]{Example}
\newtheorem{xca}[theorem]{Exercise}

%\theoremstyle{remark}
\newtheorem{remark}[theorem]{Remark}

\numberwithin{equation}{section}

\makeatletter
%Sectioncolor

%\def\thesection{\sffamily\textcolor{TitleBlue}{\arabic{section}}}
%\renewcommand\thesubsection{\sffamily\textcolor{AbshBlue}{\bf\thesection.\arabic{subsection}}}
\def\thefigure{\bf\textcolor{FigureBrown}{\sffamily\arabic{figure}}}
\def\thetable{\bf\textcolor{TableBlue}{\thesection\sffamily\arabic{table}}}
%\def\fnum@figure{\fontsize{11}{13}\selectfont\textcolor{TabBrown}{\textbf{Figure~\thefigure}}}
\makeatletter
\def\fnum@figure{\fontsize{11}{13}\selectfont\textcolor{TabBrown}{\textbf{\sffamily Figure~\thefigure.}}}
\def\fnum@table{\fontsize{11}{13}\selectfont\textcolor{TableBlue}{\textbf{\sffamily Tableau~\thetable.}}}
%\def\fnum@table{\tablename~\thetable}

%\newcounter {ssection}
\makeatletter
%\newcounter {headingfour}[subsubsection]
\def\secsize{\@setfontsize\secsize{12\p@}{14\p@}}
\renewcommand\section{\@startsection {section}{1}{\z@}%
                                   {-3.5ex \@plus -1ex \@minus -.2ex}%
                                   {2.3ex \@plus.2ex}%
                                   {\normalfont\secsize\bfseries\sffamily\color{SecoBlue} }}
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\normalfont\secsize\itshape\bfseries\sffamily\color{SectBlue}}}
\renewcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\normalfont\secsize\sffamily\color{SecthBlue}}}
\renewcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\normalfont\secsize\sffamily\color{SecfBlue}}}
%\newcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
%                                    {3.25ex \@plus1ex \@minus.2ex}%
%                                    {-1em}%
%                                    {\normalfont\normalsize\bfseries}}
%\newcommand\subparagraph{\@startsection{subparagraph}{5}{\parindent}%
%                                       {3.25ex \@plus1ex \@minus .2ex}%
%                                       {-1em}%
%                                      {\normalfont\normalsize\bfseries}}
\makeatother
%\renewcommand{\thefootnote}{\fnsymbol{footnote}}
\setlength{\skip\footins}{24pt}
%\newcounter {subsubsection}%[subsection]
\makeatletter
\renewcommand\thepage{\arabic{page}}
\renewcommand\thepart{\Roman{part}}
\renewcommand\thechapter{\arabic{chapter}}
%\renewcommand \thesection {\bfseries\sffamily\@arabic\c@section.}
%\renewcommand\thesubsection   {\upshape\bfseries\sffamily\thesection.\@arabic\c@subsection.}
%\renewcommand\thesubsubsection{\sffamily\thesubsection.\@arabic\c@subsubsection}
\renewcommand\thesection{\sffamily\arabic{section}.}
\renewcommand\thesubsection{\upshape\sffamily\thesection\arabic{subsection}.}
\renewcommand\thesubsubsection{{\sffamily\thesubsection\arabic{subsubsection}}.}
\renewcommand\theparagraph{\sffamily\thesubsubsection\arabic{paragraph}.}
\renewcommand\thesubparagraph{\theparagraph.\arabic{subparagraph}}
\renewcommand\theequation{\arabic{equation}}
\renewcommand\@chapapp{\chaptername}
\makeatother
\makeatletter

% this creates a custom and simpler ruled box style
\newcommand\floatc@simplerule[2]{{\@fs@cfont #1 #2}\par}
\newcommand\fs@simplerule{\def\@fs@cfont{\bfseries}\let\@fs@capt\floatc@simplerule
  \def\@fs@pre{\hrule height.8pt depth0pt \kern4pt}%
  \def\@fs@post{\kern4pt\hrule height.8pt depth0pt \kern4pt \relax}%
  \def\@fs@mid{\kern8pt}%
  \let\@fs@iftopcapt\iftrue}

% this code block defines the new and custom floatbox float environment
\floatstyle{simplerule}
\newfloat{floatbox}{thp}{lob}[section]
\floatname{floatbox}{Box}

\makeatletter
%\let\defaultsize\bibsize
\renewcommand\@biblabel[1]{}
\newdimen\bibindent
\setlength\bibindent{1.5em}
\def\refname{Bibliographie}
\renewenvironment{thebibliography}[1]
     {\fontsize{11}{13}\selectfont
     \section*{\bibname}%
      \@mkboth{\MakeUppercase\bibname}{\MakeUppercase\bibname}%
      \list{\@biblabel{\@arabic\c@enumiv}}%
           {\settowidth\labelwidth{\@biblabel{#1}}%
            \leftmargin\labelwidth
            \advance\leftmargin\labelsep
            \@openbib@code
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\@arabic\c@enumiv}}%
      \sloppy
      \clubpenalty4000
      \@clubpenalty \clubpenalty
      \widowpenalty4000%
      \sfcode`\.\@m}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}

%\renewenvironment{thebibliography}[1]
%     {\fontsize{9}{11}\selectfont
%     \textcolor{HeadBlue}%\hrule
%     %\vskip-12pt
%     %\begin{flushleft}
%     %\FontBib{Bibliography} %\vskip-12pt}
%     %\end{flushleft}
%     %\egroup\relax
%     %\section*{\refname}%
%     %\textcolor{HeadBlue}\hrule
%           %\@mkboth{\MakeUppercase\refname}{\MakeUppercase\refname}%
%      \list{\@biblabel{\@arabic\c@enumiv}}%
%           {\settowidth\labelwidth{\@biblabel{#1}}%
%            \leftmargin\labelwidth
%            \advance\leftmargin\labelsep
%            \@openbib@code
%            \usecounter{enumiv}%
%            \let\p@enumiv\@empty
%            \renewcommand\theenumiv{\@arabic\c@enumiv}}%
%      \sloppy
%      \clubpenalty4000
%      \@clubpenalty \clubpenalty
%      \widowpenalty4000%
%      \sfcode`\.\@m}
%     {\def\@noitemerr
%       {\@latex@warning{Empty `thebibliography' environment}}%
%      \endlist}
%\newcommand\newblock{\hskip .11em\@plus.33em\@minus.07em}
%\let\@openbib@code\@empty
\thispagestyle{fancy}
%\def\ps@headings{%
%  \def\@oddfoot{\relax}%
%  \def\@evenfoot{\relax}%
%\def\@oddhead{\relax}%
% \def\@evenhead{\relax}%
% \def\@evenhead{%\hskip-9.4pc

% {\vbox{\vspace*{18\p@}\fontsize{10}{11}\selectfont{{
%  \sffamily\hskip6\p@ \leftmark \hfill \thepage\par}}\vspace*{-4.5\p@}%
%\hskip6\p@\rule{188.8truemm}{.5\p@}}}}%

  %\def\@evenhead{\hskip-9.4pc{\vbox{\fontsize{10}{11}\selectfont{\thepage\hskip18pt{\it \leftmark\par}}\vspace*{-4.5\p@}%
%\rule{142truemm}{.5\p@}}}}%

 % \def\@oddhead{{\vbox{\vspace*{18\p@}\fontsize{10}{11}\selectfont{{
%  \sffamily\hskip6\p@ \color{HeadBlue}\rightmark \hfill \thepage\par}}\vspace*{-4.5\p@}
%\color{HeadBlue}\hskip6\p@\rule{188.8truemm}{.5\p@}}}}
%}

  %\hfill {\it \rightmark}\hskip18pt\thepage\par\vspace*{-4.5\p@}%
%\hskip-9.5pc\rule{188.8truemm}{0.5\p@}
%}%
%  }}%
%}
\makeatother
%\def\rightmark{Bibliography}

\makeatletter
\newcommand*{\note}[1]{
\noindent\colorbox{YBox}{\parbox{\linewidth}{\textsc{\bfseries Remarque.} #1}}}
\makeatletter
\def\blfootnote{\xdef\@thefnmark{}\@footnotetext}
\makeatother


\pagestyle{fancy}
\endinput
